/**************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing/
**
** This file is part of the Qt Installer Framework.
**
** $QT_BEGIN_LICENSE:LGPL21$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 or version 3 as published by the Free
** Software Foundation and appearing in the file LICENSE.LGPLv21 and
** LICENSE.LGPLv3 included in the packaging of this file. Please review the
** following information to ensure the GNU Lesser General Public License
** requirements will be met: https://www.gnu.org/licenses/lgpl.html and
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** As a special exception, The Qt Company gives you certain additional
** rights. These rights are described in The Qt Company LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** $QT_END_LICENSE$
**
**************************************************************************/
#include "packagemanagerdynamicinstallerpage.h"
#include "packagemanagercore.h"

#include "component.h"
#include "componentmodel.h"
#include "errors.h"
#include "fileutils.h"
#include "messageboxhandler.h"
#include "packagemanagercore.h"
#include "progresscoordinator.h"
#include "performinstallationform.h"
#include "settings.h"
#include "utils.h"
#include "scriptengine.h"
#include "productkeycheck.h"

#include <QApplication>

#include <QString>
#include <QSettings>
#include <QtCore/QDir>
#include <QtCore/QPair>
#include <QtCore/QProcess>
#include <QtCore/QTimer>
#include <QTranslator>
#include <QDir>
#include <QDirIterator>
#include <QTextCodec>
#include <QFileInfo>
#include <QStringList>
#include <QScopedPointer>

#include <QCheckBox>
#include <QDesktopServices>
#include <QFileDialog>
#include <QGridLayout>
#include <QHBoxLayout>
#include <QHeaderView>
#include <QLabel>
#include <QLineEdit>
#include <QListWidget>
#include <QListWidgetItem>
#include <QMessageBox>
#include <QProgressBar>
#include <QPushButton>
#include <QRadioButton>
#include <QTextBrowser>
#include <QTreeView>
#include <QVBoxLayout>
#include <QShowEvent>
#include <QComboBox>

#ifdef Q_OS_WIN
# include <qt_windows.h>
# include <QWinTaskbarButton>
# include <QWinTaskbarProgress>
#endif

using namespace KDUpdater;
using namespace QInstaller;

DynamicInstallerPage::DynamicInstallerPage(QWidget *widget, PackageManagerCore *core)
    : PackageManagerPage(core)
    , m_widget(widget)
{
    setObjectName(QLatin1String("Dynamic") + widget->objectName());
    setPixmap(QWizard::WatermarkPixmap, QPixmap());

    setColoredSubTitle(QLatin1String(" "));
    setColoredTitle(widget->windowTitle());
    m_widget->setProperty("complete", true);
    m_widget->setProperty("final", false);
    m_widget->setProperty("commit", false);
    widget->installEventFilter(this);

    setLayout(new QVBoxLayout);
    layout()->addWidget(widget);
    layout()->setContentsMargins(0, 0, 0, 0);
    layout()->addItem(new QSpacerItem(20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding));

    addPageAndProperties(packageManagerCore()->controlScriptEngine());
    addPageAndProperties(packageManagerCore()->componentScriptEngine());
}

QWidget *DynamicInstallerPage::widget() const
{
    return m_widget;
}

bool DynamicInstallerPage::isComplete() const
{
    return m_widget->property("complete").toBool();
}

void DynamicInstallerPage::setFinal(bool final) {
    if (isFinal() == final)
        return;
    m_widget->setProperty("final", final);
}
bool DynamicInstallerPage::isFinal() const {
    return m_widget->property("final").toBool();
}

void DynamicInstallerPage::setCommit(bool commit) {
    if (isCommit() == commit)
        return;
    m_widget->setProperty("commit", commit);
}
bool DynamicInstallerPage::isCommit() const {
    return m_widget->property("commit").toBool();
}

void DynamicInstallerPage::setComplete(bool complete) {
    if (isComplete() == complete)
        return;
    m_widget->setProperty("complete", complete);
}

bool DynamicInstallerPage::eventFilter(QObject *obj, QEvent *event)
{
    if (obj == m_widget) {
        switch(event->type()) {
        case QEvent::WindowTitleChange:
            setColoredTitle(m_widget->windowTitle());
            break;

        case QEvent::DynamicPropertyChange:
            emit completeChanged();
            if (m_widget->property("final").toBool() != isFinalPage())
                setFinalPage(m_widget->property("final").toBool());
            if (m_widget->property("commit").toBool() != isCommitPage())
                setCommitPage(m_widget->property("commit").toBool());
            break;

        default:
            break;
        }
    }
    return PackageManagerPage::eventFilter(obj, event);
}

void DynamicInstallerPage::addPageAndProperties(ScriptEngine *engine)
{
    engine->addToGlobalObject(this);
    engine->addToGlobalObject(widget());

    static const QStringList properties = QStringList() << QStringLiteral("final")
        << QStringLiteral("commit") << QStringLiteral("complete");
    foreach (const QString &property, properties) {
        engine->evaluate(QString::fromLatin1(
            "Object.defineProperty(%1, \"%2\", {"
                "get : function() { return Dynamic%1.%2; },"
                "set: function(val) { Dynamic%1.%2 = val; }"
            "});"
        ).arg(m_widget->objectName(), property));
    }
}
